local prefabs =
{
    "nightmarefuel",
	"warlock_ball",
}

weapontypes = {"nightmareaxe", "nightmarepickaxe", "nightmareshovel", "nightmarehammer", "nightsword"}

local function retargetfn(inst)
    local entity = FindEntity(inst, TUNING.SHADOWCREATURE_TARGET_DIST, function(guy) 
		return guy:HasTag("player") and guy.components.sanity:IsCrazy() and inst.components.combat:CanTarget(guy)
    end)
    return entity
end

local function onkilledbyother(inst, attacker)
	if attacker and attacker.components.sanity then
		attacker.components.sanity:DoDelta(inst.sanityreward or TUNING.SANITY_SMALL)
	end
end

SetSharedLootTable( 'shadow_creature',
{
    {'nightmarefuel',  1.0},
    {'nightmarefuel',  0.5},
	{'nightmarefuel',  0.1},
})

local function CalcSanityAura(inst, observer)
	if inst.components.combat.target then
		return -TUNING.SANITYAURA_LARGE
	end	
	return 0
end

local function canbeattackedfn(inst, attacker)
	return inst.components.combat.target ~= nil or
		(attacker and attacker.components.sanity and attacker.components.sanity:IsCrazy())
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30, function(dude) return dude:HasTag("shadowcreature") and not dude.components.health:IsDead() end, 1)
end

local function WeaponDropped(inst)
    inst:Remove()
end

local function EquipWeapon(inst)
    if inst.components.inventory and not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) then
        
		local weapon = SpawnPrefab(weapontypes[math.random(1, #weapontypes)])
        weapon.entity:AddTransform() 

        weapon:AddTag("sharp")
        
		if weapon then			
			weapon.AnimState:SetMultColour(0.0,0.0,0.0,0.5)
		end
		
        weapon.persists = false
        weapon.components.inventoryitem:SetOnDroppedFn(WeaponDropped)
        
        inst.components.inventory:Equip(weapon)
    end
end

local function WarlockBall(inst)
    if inst.components.inventory and not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) then
        local weapon = CreateEntity()
        weapon.entity:AddTransform()
        weapon:AddComponent("weapon")
        weapon.components.weapon:SetDamage(inst.components.combat.defaultdamage)
        weapon.components.weapon:SetRange(inst.components.combat.attackrange, inst.components.combat.attackrange+4)
        weapon.components.weapon:SetProjectile("warlock_ball")
        weapon:AddComponent("inventoryitem")
        weapon.persists = false
        weapon.components.inventoryitem:SetOnDroppedFn(WeaponDropped)
        weapon:AddComponent("equippable")
        
        inst.components.inventory:Equip(weapon)
    end
end

local function MakeShadowCreature(data)

    local bank = data.bank 
    local build = data.build 
    
    local assets=
    {
	    Asset("ANIM", "anim/"..data.build..".zip"),
    }
    
    local sounds = 
    {
        attack = "dontstarve/sanity/creature"..data.num.."/attack",
        attack_grunt = "dontstarve/sanity/creature"..data.num.."/attack_grunt",
        death = "dontstarve/sanity/creature"..data.num.."/die",
        idle = "dontstarve/sanity/creature"..data.num.."/idle",
        taunt = "dontstarve/sanity/creature"..data.num.."/taunt",
        appear = "dontstarve/sanity/creature"..data.num.."/appear",
        disappear = "dontstarve/sanity/creature"..data.num.."/dissappear",
    }

    local function fn()
	    local inst = CreateEntity()
	    local trans = inst.entity:AddTransform()
	    local anim = inst.entity:AddAnimState()
        local physics = inst.entity:AddPhysics()
	    local sound = inst.entity:AddSoundEmitter()
        inst.Transform:SetFourFaced()
        inst:AddTag("shadowcreature")
    	
        MakeCharacterPhysics(inst, 10, 1.5)
        RemovePhysicsColliders(inst)
	    inst.Physics:SetCollisionGroup(COLLISION.SANITY)
	    inst.Physics:CollidesWith(COLLISION.SANITY)
	    --inst.Physics:CollidesWith(COLLISION.WORLD)
        
         
        anim:SetBank(bank)
        anim:SetBuild(build)
        anim:PlayAnimation("idle_loop")
        anim:SetMultColour(1, 1, 1, 0.5)
        inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
        inst.components.locomotor.walkspeed = data.speed
        inst.sounds = sounds
		inst:SetStateGraph("SG"..data.stategraph)
		
        inst:AddTag("monster")
	    inst:AddTag("hostile")
        inst:AddTag("shadow")
        inst:AddTag("notraptrigger")

        local brain = require "brains/shadowcreaturebrain"
        inst:SetBrain(brain)
        
	    inst:AddComponent("sanityaura")
	    inst.components.sanityaura.aurafn = CalcSanityAura
        
        inst:AddComponent("transparentonsanity")
        inst:AddComponent("health")
        inst.components.health:SetMaxHealth(data.health)
        
		inst.sanityreward = data.sanityreward
		
        inst:AddComponent("combat")
        inst.components.combat:SetDefaultDamage(data.damage)
        inst.components.combat:SetAttackPeriod(data.attackperiod)
        inst.components.combat:SetRetargetFunction(3, retargetfn)
        inst.components.combat.onkilledbyother = onkilledbyother
        inst.components.combat.canbeattackedfn = canbeattackedfn
		
		if data.name == "scaryspider" then
		inst.components.combat:SetRange(TUNING.SPIDER_WARRIOR_ATTACK_RANGE, TUNING.SPIDER_WARRIOR_HIT_RANGE)
		end
		
		if data.name == "creepyman" then
		inst:AddComponent("creep_speech")
		inst:AddComponent("talker")
		inst.components.talker.fontsize = 25
		inst.components.talker.font = TALKINGFONT
		inst.components.talker.colour = Vector3(.4, .4, .4, .7)
		inst.components.talker.offset = Vector3(0,-450,0)
		inst:AddComponent("inventory")
		EquipWeapon(inst)
		inst.AnimState:Show("ARM_carry") 
		inst.AnimState:Hide("ARM_normal")
		end
		
		if data.name == "wickedwarlock" then
		inst.components.combat:SetRange(TUNING.BISHOP_ATTACK_DIST*5)
		inst.components.combat.hiteffectsymbol = "waist"
		inst:AddComponent("inventory")
		inst:DoTaskInTime(1, WarlockBall)
		end
		
		if data.name == "shadowbug" then
		inst.AnimState:SetScale(2, 2, 2)
		end

        inst:AddComponent("lootdropper")
        inst.components.lootdropper:SetChanceLootTable('shadow_creature')
        
        inst:ListenForEvent("attacked", OnAttacked)

        return inst
    end
        
    return Prefab("monsters/"..data.name, fn, assets, prefabs)
end


local data = {
			  {name="crawlinghorror", build = "shadow_insanity1_basic", bank = "shadowcreature1", num = 1, speed = TUNING.CRAWLINGHORROR_SPEED, health=TUNING.CRAWLINGHORROR_HEALTH, damage=TUNING.CRAWLINGHORROR_DAMAGE, attackperiod = TUNING.CRAWLINGHORROR_ATTACK_PERIOD, sanityreward = TUNING.SANITY_MED, stategraph = "shadowcreature"},
			  
			  {name="terrorbeak", build = "shadow_insanity2_basic", bank = "shadowcreature2", num = 2, speed = TUNING.TERRORBEAK_SPEED, health=TUNING.TERRORBEAK_HEALTH, damage=TUNING.TERRORBEAK_DAMAGE, attackperiod = TUNING.TERRORBEAK_ATTACK_PERIOD, sanityreward = TUNING.SANITY_LARGE, stategraph = "shadowcreature"},
			  
			  {name="horridbatt", build = "horridbatt", bank = "bat", num = 2, speed = TUNING.TERRORBEAK_SPEED, health=TUNING.CRAWLINGHORROR_HEALTH*0.7, damage=TUNING.TERRORBEAK_DAMAGE*0.20, attackperiod = TUNING.TERRORBEAK_ATTACK_PERIOD, sanityreward = TUNING.SANITY_MED, stategraph = "horridbatt"},
			  
			  {name="wretchedrock", build = "wretchedrock", bank = "rocky", num = 1, speed = TUNING.CRAWLINGHORROR_SPEED*0.5, health=TUNING.TERRORBEAK_HEALTH*2.5, damage=TUNING.TERRORBEAK_DAMAGE*1.4, attackperiod = TUNING.CRAWLINGHORROR_ATTACK_PERIOD*3, sanityreward = TUNING.SANITY_LARGE, stategraph = "wretchedrock"},
			  
			  {name="scaryspider", build = "scaryspider", bank = "spider", num = 2, speed = TUNING.TERRORBEAK_SPEED, health=TUNING.CRAWLINGHORROR_HEALTH, damage=TUNING.CRAWLINGHORROR_DAMAGE, attackperiod = TUNING.CRAWLINGHORROR_ATTACK_PERIOD, sanityreward = TUNING.SANITY_MED, stategraph = "scaryspider"},
			  
			  {name="creepyman", build = "creepyman", bank = "wilson", num = 1, speed = TUNING.TERRORBEAK_SPEED, health=TUNING.TERRORBEAK_HEALTH, damage=TUNING.TERRORBEAK_DAMAGE, attackperiod = TUNING.TERRORBEAK_ATTACK_PERIOD, sanityreward = TUNING.SANITY_LARGE, stategraph = "creepyman"},
			  
			  {name="wickedwarlock", build = "wickedwarlock", bank = "bishop", num = 1, speed = TUNING.CRAWLINGHORROR_SPEED*1.3, health=TUNING.TERRORBEAK_HEALTH*1.2, damage=TUNING.CRAWLINGHORROR_DAMAGE*0.9, attackperiod = TUNING.CRAWLINGHORROR_ATTACK_PERIOD*1.4, sanityreward = TUNING.SANITY_LARGE, stategraph = "wickedwarlock"},
			  
			  {name="shadowbug", build = "shadowbug", bank = "bee", num = 2, speed = TUNING.TERRORBEAK_SPEED*2, health=TUNING.TERRORBEAK_HEALTH*0.5, damage=TUNING.CRAWLINGHORROR_DAMAGE*0.5, attackperiod = TUNING.TERRORBEAK_ATTACK_PERIOD, sanityreward = TUNING.SANITY_MED, stategraph = "shadowbug"}
			 }

local ret = {}
for k,v in pairs(data) do
	table.insert(ret, MakeShadowCreature(v))
end


return unpack(ret) 
